package examples;

import org.pgusb.usb4allLib.Usb4allDevice;
import exceptions.Usb4allException;


public class LoopBack extends Usb4allDevice {
	
	//skeleton
	private static final int IN_ENDPOINT_TYPE = Usb4allDevice.BULK_IN; //Replace with the prefered In Endpoint Type.
	private static final int OUT_ENDPOINT_TYPE = Usb4allDevice.BULK_OUT; //Replace with the prefered Out Endpoint Type.
	
	public LoopBack(String moduleName){
		super(IN_ENDPOINT_TYPE,OUT_ENDPOINT_TYPE);
		this.moduleName=moduleName;
	}
	
	public LoopBack(String moduleName, int inEndpointType, int outEndpointType){
		super(inEndpointType,outEndpointType);
		this.moduleName=moduleName;
	}
	
	public LoopBack(int inEndpointType, int outEndpointType){
		super(inEndpointType,outEndpointType);
		moduleName="lback"; //Put the name of the firmware module.
	}
	
	public LoopBack(){
		super(IN_ENDPOINT_TYPE,OUT_ENDPOINT_TYPE);
		moduleName="lback"; //Put the name of the firmware module.
	}

	public byte[] sendReceive(byte[] sendBytes){
		byte[] receivedBytes=null;  
		try {
			send(sendBytes);
			receivedBytes = receive(sendBytes.length);
		} catch (Usb4allException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return receivedBytes;
	}

	}